<?php

spl_autoload_register(function (string $class): void {
    $prefix = 'WebniamPayment\\';
    $baseDir = __DIR__ . '/src/WebniamPayment/';

    if (strncmp($prefix, $class, strlen($prefix)) !== 0) {
        return;
    }

    $relativeClass = substr($class, strlen($prefix));
    $path = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';

    if (is_file($path)) {
        require_once $path;
    }
});
