<?php

namespace WebniamPayment\Http;

use WebniamPayment\Exceptions\HttpException;
use WebniamPayment\Response\ApiResponse;

class CurlHttpClient implements HttpClientInterface
{
    /**
     * @param array<mixed> $payload
     */
    public function post(string $url, array $payload, array $headers = []): ApiResponse
    {
        $ch = curl_init($url);
        if ($ch === false) {
            throw new HttpException('Unable to initialize curl');
        }

        $body = json_encode($payload, JSON_UNESCAPED_SLASHES);
        if ($body === false) {
            throw new HttpException('Unable to encode payload as JSON');
        }

        $defaultHeaders = [
            'Content-Type: application/json',
            'Accept: application/json',
        ];

        $mergedHeaders = array_merge($defaultHeaders, $headers);

        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => $mergedHeaders,
            CURLOPT_POSTFIELDS => $body,
            CURLOPT_TIMEOUT => 30,
        ]);

        $responseBody = curl_exec($ch);
        if ($responseBody === false) {
            $error = curl_error($ch);
            curl_close($ch);
            throw new HttpException('HTTP request failed: ' . $error);
        }

        $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE) ?: 0;
        curl_close($ch);

        $decoded = json_decode($responseBody, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            $decoded = null;
        }

        return new ApiResponse($statusCode, $decoded, $responseBody);
    }
}
