<?php

namespace WebniamPayment\Response;

class ApiResponse
{
    private int $statusCode;

    /**
     * @var array<mixed>|null
     */
    private $body;

    private string $rawBody;

    public function __construct(int $statusCode, ?array $body, string $rawBody)
    {
        $this->statusCode = $statusCode;
        $this->body = $body;
        $this->rawBody = $rawBody;
    }

    public function getStatusCode(): int
    {
        return $this->statusCode;
    }

    /**
     * @return array<mixed>|null
     */
    public function getBody(): ?array
    {
        return $this->body;
    }

    public function getRawBody(): string
    {
        return $this->rawBody;
    }

    public function isTransportSuccess(): bool
    {
        return $this->statusCode >= 200 && $this->statusCode < 300;
    }

    public function isApiSuccess(): bool
    {
        return $this->isTransportSuccess() && is_array($this->body) && ($this->body['success'] ?? false) === true;
    }
}
